// /////////////////////////////////////////////////////////////////////////////
// DR DOBB'S CHALLENGES
//
// Filename       : intro.cpp
// Date           : February 2008
//
// Description    : Refer to description in corresponding header.
//
// ///////////////////////////////////////////////////////////////////////////


#include "intro.h"
#include "input.h"
#include "Application.h"



CIntro::CIntro() 
{
  // Initialize remaining members
  closeIntro = false;
  clickLeft  = false;
  m_FirstFrameDisplayed = false;
  m_IntroStateTime      = 0.0f;

  for ( int i = 0; i < 3; ++i )
  {
    m_SpeechStarted[i] = false;
  }

}



CIntro::~CIntro() 
{

  g_App.StopSound( "Intro.1" );
  g_App.StopSound( "Intro.2" );
  g_App.StopSound( "Intro.3" );

}



void CIntro::Update() 
{

  if ( g_App.m_Input.AnyKeyPressed() )
  {
    closeIntro = true;
  }

  if ( g_App.m_Input.MouseButtonDown( 1 ) ) 
  {
    clickLeft = true; 
  } 
  else 
  {
    if ( clickLeft )
    {
      closeIntro = true;
    }
  }

  if ( Close() ) 
  {
    g_App.ChangeGameState( new Menu() );
  }

}



bool CIntro::Close() 
{ 
  return closeIntro; 
}



void CIntro::RenderText( const std::string& Text, int X, int Y, float StartTime, float EndTime )
{

  if ( ( m_IntroStateTime < StartTime )
  ||   ( m_IntroStateTime > EndTime ) )
  {
    return;
  }
  if ( m_IntroStateTime >= EndTime - 1.0f )
  {
    g_App.RenderText( "Extro", Text, X, Y, 0x00ffffff + ( ( (int)( 255 * ( EndTime - m_IntroStateTime ) ) ) << 24 ) );
  }
  else if ( m_IntroStateTime >= StartTime + 1.0f )
  {
    g_App.RenderText( "Extro", Text, X, Y );
  }
  else
  {
    g_App.RenderText( "Extro", Text, X, Y, 0x00ffffff + ( ( (int)( 255 * ( m_IntroStateTime - StartTime ) ) ) << 24 ) );
  }

}



void CIntro::RenderCursor( int X, int Y, float StartTime, float EndTime )
{

  if ( ( m_IntroStateTime < StartTime )
  ||   ( m_IntroStateTime > EndTime ) )
  {
    return;
  }
  if ( fmodf( m_IntroStateTime, 0.2f ) < 0.1f )
  {
    // let the cursor blink
    return;
  }
  if ( m_IntroStateTime >= EndTime - 1.0f )
  {
    g_App.RenderTextureSection( "Cursor", X, Y, 0x00ffffff + ( ( (int)( 255 * ( EndTime - m_IntroStateTime ) ) ) << 24 ) );
  }
  else if ( m_IntroStateTime >= StartTime + 1.0f )
  {
    g_App.RenderTextureSection( "Cursor", X, Y );
  }
  else
  {
    g_App.RenderTextureSection( "Cursor", X, Y, 0x00ffffff + ( ( (int)( 255 * ( m_IntroStateTime - StartTime ) ) ) << 24 ) );
  }

}



void CIntro::Render()
{

  if ( !m_FirstFrameDisplayed )
  {
    m_FirstFrameDisplayed = true;
  }

  g_App.Clear();

  if ( ( m_IntroStateTime >= 1.0f )
  &&   ( m_IntroStateTime <= 2.0f ) )
  {
    g_App.RenderTextureSection( "Shodan", 20, 20, 0x00ffffff + ( ( (int)( 255 * ( m_IntroStateTime - 1.0f ) ) ) << 24 ) );
  }
  else if ( ( m_IntroStateTime >= 25.0f )
  &&        ( m_IntroStateTime <= 26.0f ) )
  {
    g_App.RenderTextureSection( "Shodan", 20, 20, 0x00ffffff + ( ( (int)( 255 * ( 26.0f - m_IntroStateTime ) ) ) << 24 ) );
  }
  else if ( ( m_IntroStateTime >= 2.0f )
  &&        ( m_IntroStateTime < 25.0f ) )
  {
    g_App.RenderTextureSection( "Shodan", 20, 20 );
  }

  RenderText( "Welcome Dr. Dobb", 150, 30, 3.0f, 11.0f );
  RenderText( "I apologize for the interruption.", 150, 70, 4.0f, 11.0f );
  RenderText( "I have transferred you into my system", 150, 110, 5.0f, 11.0f );
  RenderText( "because i need your help", 150, 150, 6.0f, 11.0f );
  RenderCursor( 560, 151, 6.0f, 11.0f );

  RenderText( "Bugs have infested my system", 150, 30, 12.0f, 20.0f );
  RenderText( "and i need you to debug it.", 150, 70, 13.0f, 20.0f );
  RenderText( "I can give you remote instructions", 150, 110, 14.0f, 20.0f );
  RenderText( "but once inside you are on your own", 150, 150, 15.0f, 20.0f );
  RenderCursor( 750, 151, 15.0f, 20.0f );

  RenderText( "Initiate transport sequence", 150, 30, 21.0f, 26.0f );
  RenderCursor( 600, 31, 21.0f, 26.0f );

}



void CIntro::UpdateTimed( const float ElapsedTime )
{

  if ( m_FirstFrameDisplayed )
  {
    m_IntroStateTime += ElapsedTime;
    if ( m_IntroStateTime >= 28.0f )
    {
      g_App.ChangeGameState( new Menu() );
    }
  }

  if ( ( m_IntroStateTime >= 3.0f )
  &&   ( !m_SpeechStarted[0] ) )
  {
    m_SpeechStarted[0] = true;
    g_App.PlaySound( "Intro.1" );
  }
  if ( ( m_IntroStateTime >= 12.0f )
  &&   ( !m_SpeechStarted[1] ) )
  {
    m_SpeechStarted[1] = true;
    g_App.PlaySound( "Intro.2" );
  }
  if ( ( m_IntroStateTime >= 21.0f )
  &&   ( !m_SpeechStarted[2] ) )
  {
    m_SpeechStarted[2] = true;
    g_App.PlaySound( "Intro.3" );
  }

}